import os
import xbmc
import base64
import threading

from xbmc import Monitor
from six.moves import urllib_request

from elementum.daemon import shutdown
from elementum.config import init, ELEMENTUMD_HOST, ONLY_CLIENT
from kodi_six.utils import PY2


class ElementumMonitor(Monitor):
    def __init__(self):
        self._closing = threading.Event()
        self._reboot = False
        Monitor.__init__(self)

    def __str__(self):
        return 'ElementumMonitor'

    @property
    def closing(self):
        return self._closing

    def restart(self):
        try:
            init()
            urllib_request.urlopen("%s/restart" % ELEMENTUMD_HOST)
        except:
            pass

    def reboot(self, val=None):
        if val is not None:
            self._reboot = val

        return self._reboot

    def onAbortRequested(self):
        # Only when closing Kodi
        if self.abortRequested():
            xbmc.executebuiltin("Dialog.Close(all, true)")
            if not ONLY_CLIENT:
                shutdown()
            try:
                self._closing.set()
                self._closing.clear()
            except SystemExit as e:
                if e.code != 0:
                    os._exit(0)
                pass

    def onSettingsChanged(self):
        try:
            init()
            urllib_request.urlopen("%s/reload" % ELEMENTUMD_HOST)
            urllib_request.urlopen("%s/cmd/clear_page_cache" % ELEMENTUMD_HOST)
        except:
            pass

    def onNotification(self, sender, method, data):
        if method and "elementum_restart" in method:
            self.restart()
            self.reboot(True)

            return

        try:
            if PY2:
                data_base64 = base64.b64encode(data)
            else:
                data_base64 = base64.b64encode(data.encode("utf-8")).decode("utf-8")

            urllib_request.urlopen("%s/notification?sender=%s&method=%s&data=%s" % (
                ELEMENTUMD_HOST,
                sender,
                method,
                data_base64))
        except:
            pass
