#todo settings
import xbmcplugin,xbmcgui,xbmcaddon,plugintools,os,sys,json,requests,base64,time
import xml.etree.ElementTree as ET
from datetime import datetime,timedelta
from os.path import exists

IMAGES = os.path.join(plugintools.get_runtime_path(),"resources","images")
CACHE = os.path.join(plugintools.get_runtime_path(),"resources","cache")
if not plugintools.get_setting("kasutajanimi"):
	plugintools.open_settings_dialog()

panel_url = "http://live.stevetv.com.au:80/"
if not plugintools.get_setting("kasutajanimi") or not plugintools.get_setting("parool"):
	plugintools.open_settings_dialog()
kasutajanimi = plugintools.get_setting("kasutajanimi")
parool = plugintools.get_setting("parool")
kava = plugintools.get_setting("kava")
buffermalu = plugintools.get_setting("buffermalu")
valjund = plugintools.get_setting("striimivaljund")
def run():
	plugintools.log("Starting up");
	global panel_url
	global kasutajanimi
	global parool
	global kava
	global buffermalu
	global valjund
	params = plugintools.get_params()
	if params.get("action") is None:
		main(params)
	else:
		exec(params.get("action")+"(params)")
	plugintools.close_item_list()
	
def main(params):
	plugintools.log("Main")
	auth = login()
	if auth == 1:
		plugintools.add_item( action = "account_info" , title = "My account" ,thumbnail = os.path.join(IMAGES,"account_icon.png" ),fanart = os . path . join (IMAGES,"background.jpg"), folder = True )
		plugintools.add_item( action = "get_live_categories" , title = "Tv" ,thumbnail = os.path.join(IMAGES,"live_icon.png" ),fanart = os . path . join (IMAGES,"background.jpg"), folder = True )
		plugintools.add_item( action = "get_vod_categories" , title = "Movies" ,thumbnail = os.path.join(IMAGES,"vod_icon.png" ),fanart = os . path . join (IMAGES,"background.jpg"), folder = True )
		plugintools.add_item( action = "get_series_categories" , title = "Series" ,thumbnail = os.path.join(IMAGES,"series_icon.png" ),fanart = os . path . join (IMAGES,"background.jpg"), folder = True )
		plugintools.add_item( action = "get_tv_archive" , title = "Tv archive" ,thumbnail = os.path.join(IMAGES,"replay_icon.png" ),fanart = os . path . join (IMAGES,"background.jpg"), folder = True )
		plugintools.add_item( action = "settings" , title = "Settings" ,thumbnail = os.path.join(IMAGES,"settings_icon.png" ),fanart = os . path . join (IMAGES,"background.jpg"), folder = False )
		plugintools.set_view(plugintools.LIST)
	else:
		plugintools.message("Error","Login failed, please check your creditentials!")
		exit()
#GET ACCOUNT INFO	
def account_info(params):
	r = requests.get(url=panel_url+"player_api.php?username="+kasutajanimi+"&password="+parool)
	data = json.loads(r.content.decode())
	#status
	status =  data["user_info"]["status"] 
	#check if trial
	trial = data["user_info"]["is_trial"]
	if trial == "0":
		trial = "No"
	else:
		trial = "Yes"
	#check expire date
	expire_date = data["user_info"]["exp_date"]
	if expire_date:
		expires = datetime.fromtimestamp(int(expire_date)).strftime("%d.%m.%Y %H:%M")
	else:
		expires = "Never"
	#max connections
	max_connections =  data["user_info"]["max_connections"] 
	plugintools . add_item ( action = "" , title = "[B]Username: [/B]"+kasutajanimi ,thumbnail = os.path.join(IMAGES,"account_icon.png" ),fanart = os . path . join (IMAGES,"background.jpg"), folder = False )
	plugintools . add_item ( action = "" , title = "[B]Status: [/B]"+status ,thumbnail = os.path.join(IMAGES,"account_icon.png" ),fanart = os . path . join (IMAGES,"background.jpg"), folder = False )
	plugintools . add_item ( action = "" , title = "[B]Expires: [/B]"+expires ,thumbnail = os.path.join(IMAGES,"account_icon.png" ),fanart = os . path . join (IMAGES,"background.jpg"), folder = False )
	plugintools . add_item ( action = "" , title = "[B]Trial: [/B]"+trial ,thumbnail = os.path.join(IMAGES,"account_icon.png" ),fanart = os . path . join (IMAGES,"background.jpg"), folder = False )
	plugintools . add_item ( action = "" , title = "[B]Max connections: [/B]"+max_connections ,thumbnail = os.path.join(IMAGES,"account_icon.png" ),fanart = os . path . join (IMAGES,"background.jpg"), folder = False )				
	xbmc.executebuiltin("Container.SetViewMode(55)")
#GET LIVE CATEGORIES	
def get_live_categories(params):
	r = requests.get(url=panel_url+"player_api.php?username="+kasutajanimi+"&password="+parool+"&action=get_live_categories")
	data = json.loads(r.content.decode())
	for category in data:
		category_id = category["category_id"]
		plugintools.add_item ( action = "get_live_channels" , title = category["category_name"] ,url=category_id ,thumbnail = os.path.join(IMAGES,"live_icon.png" ),fanart = os . path . join (IMAGES,"background.jpg"), folder = True )
	xbmc.executebuiltin("Container.SetViewMode(55)")
	xmltv()
#GET LIVE CHANNELS
def get_live_channels(params):
	whats_playing = on_air()
	id = params.get("url")
	r = requests.get(url=panel_url+"player_api.php?username="+kasutajanimi+"&password="+parool+"&action=get_live_streams&category_id="+id)
	data = json.loads(r.content.decode())
	plugintools.log("VALJUND"+valjund)
	if valjund == "false":
		striimivaljund = ".ts"
	else:
		striimivaljund = ".m3u8"
	for channel in data:
		name = "[B]"+channel["name"]+"[/B]"
		show_desc = "No schedule available"
		stream_id = channel["stream_id"]
		if channel["stream_icon"]:
			icon = channel["stream_icon"]
		else:
			icon = os.path.join(IMAGES,"live_icon.png")
		if kava == "true":
			if channel["epg_channel_id"]:
				if channel["epg_channel_id"]+"-title" in whats_playing.keys():#whats_playing[channel["epg_channel_id"]]:
					#epg = get_short_epg(stream_id)
					show = whats_playing[channel["epg_channel_id"]+"-title"]#epg.split("\n");
					show_desc = whats_playing[channel["epg_channel_id"]+"-time"]+" [B]"+whats_playing[channel["epg_channel_id"]+"-title"]+"[/B]\n"+whats_playing[channel["epg_channel_id"]+"-desc"]
					name = name+" - "+show
		stream_url = panel_url+"live/"+kasutajanimi+"/"+parool+"/"+str(stream_id)+striimivaljund
		#plugintools.log(str(stream_id)+"\n"+name+"\n"+stream_url)
		plugintools.add_item(action = "player", title = name ,url=stream_url ,plot=show_desc ,thumbnail = icon,fanart = os . path . join (IMAGES,"background.jpg"),folder = False,isPlayable= True )
#GET VOD CATEGORIES	
def get_vod_categories(params):
	r = requests.get(url=panel_url+"player_api.php?username="+kasutajanimi+"&password="+parool+"&action=get_vod_categories")
	data = json.loads(r.content.decode())
	for category in data:
		category_id = category["category_id"]
		plugintools.add_item ( action = "get_vod_movies" , title = category["category_name"] ,url=category_id ,thumbnail = os.path.join(IMAGES,"vod_icon.png"),fanart = os . path . join (IMAGES,"background.jpg"), folder = True )
	xbmc.executebuiltin("Container.SetViewMode(55)")
#GET VOD MOVIES
def get_vod_movies(params):
	update_cache = False
	id = params.get("url")
	r = requests.get(url=panel_url+"player_api.php?username="+kasutajanimi+"&password="+parool+"&action=get_vod_streams&category_id="+id)
	data = json.loads(r.content.decode())
	vod_cache = get_vod_cache(id)
	api_count = 0
	for channel in data:
		name = "[B]"+channel["name"]+"[/B]"
		stream_id = channel["stream_id"]
		extension = channel["container_extension"]
		
		if channel["stream_icon"]:
			icon = channel["stream_icon"]
		else:
			icon = os.path.join(IMAGES,"noposter.jpg")
		stream_url = panel_url+"movie/"+kasutajanimi+"/"+parool+"/"+str(stream_id)+"."+extension
		
		if buffermalu == "true" and str(stream_id) in vod_cache:
			plugintools.log("Found plot in vod cache. Stream id:"+str(stream_id))
			plot = vod_cache[str(stream_id)]
		else:
			plugintools.log("No plot found in vod cache, requesting from API. Stream id:"+str(stream_id))
			api_count +=1
			plot = get_vod_info_from_api(str(stream_id))
			vod_cache[str(stream_id)] = plot
			update_cache = True
			plugintools.log("API COUNT: "+str(api_count))
		#plugintools.log(str(stream_id)+"\n"+name+"\n"+stream_url)
		plugintools.add_item(action = "player", title = name ,url=str(stream_url) ,plot=plot ,thumbnail = icon,fanart = os . path . join (IMAGES,"background.jpg"),folder = False,isPlayable= True )
	if update_cache == True:
		save_vod_cache(vod_cache)
#GET SERIES CATEGORIES	
def get_series_categories(params):
	r = requests.get(url=panel_url+"player_api.php?username="+kasutajanimi+"&password="+parool+"&action=get_series_categories")
	data = json.loads(r.content.decode())
	for category in data:
		category_id = category["category_id"]
		plugintools.add_item ( action = "get_series_in_category" , title = category["category_name"] ,url=category_id ,thumbnail = os.path.join(IMAGES,"series_icon.png"),fanart = os . path . join (IMAGES,"background.jpg"), folder = True )
	xbmc.executebuiltin("Container.SetViewMode(55)")
#GET SERIES IN CATEGORY	
def get_series_in_category(params):
	id = params.get("url")
	r = requests.get(url=panel_url+"player_api.php?username="+kasutajanimi+"&password="+parool+"&action=get_series&category_id="+id)
	data = json.loads(r.content.decode())
	for series in data:
		name = series["name"]
		series_id = series["series_id"]
		if series["cover"]:
			icon = series["cover"]
		else:
			icon = os.path.join(IMAGES,"noposter.jpg")
		if series["plot"]:
			plot = series["plot"]
		else:
			plot = "No description available"
		plugintools.add_item ( action = "get_series_seasons" , title = name ,url=str(series_id) ,plot = plot,thumbnail = icon,fanart = os . path . join (IMAGES,"background.jpg"), folder = True )
	xbmc.executebuiltin("Container.SetViewMode(55)")
#GET SERIES SEASONS
def get_series_seasons(params):
	id = params.get("url")
	r = requests.get(url=panel_url+"player_api.php?username="+kasutajanimi+"&password="+parool+"&action=get_series_info&series_id="+id)
	data = json.loads(r.content.decode())
	for seasons in data["seasons"]:
		name = seasons["season_number"]
		if seasons["cover"]:
			icon = seasons["cover"]
		else:
			icon = os.path.join(IMAGES,"noposter.jpg")
		if seasons["overview"]:
			plot = seasons["overview"]
		else:
			plot = "No description available"

		plugintools.add_item(action = "get_series_episodes", title = "Season "+str(name) ,url=str(id)+":"+str(name) ,plot=plot ,thumbnail = icon,fanart = os . path . join (IMAGES,"background.jpg"),folder = True )
#GET SERIES EPISODES
def get_series_episodes(params):
	id = params.get("url")
	split = id.split(":")
	season_number = split[1]
	id = split[0]
	r = requests.get(url=panel_url+"player_api.php?username="+kasutajanimi+"&password="+parool+"&action=get_series_info&series_id="+id)
	data = json.loads(r.content.decode())
	count = 0
	for episodes in data["episodes"][season_number]:
		name = episodes["title"]
		stream_id = episodes["id"]
		container = episodes["container_extension"]
		if episodes["info"]["movie_image"]:
			icon = episodes["info"]["movie_image"]
		else:
			icon = os.path.join(IMAGES,"noposter.jpg")
		if "plot" in episodes["info"].keys():#episodes["info"]["plot"]:
			plot = episodes["info"]["plot"]
		else:
			plot = "No description available"
		stream_url = panel_url+"series/"+kasutajanimi+"/"+parool+"/"+str(stream_id)+"."+container
		#plugintools.log(str(stream_id)+"\n"+name+"\n"+stream_url)
		plugintools.add_item(action = "player", title = str(name) ,url=stream_url ,plot=plot ,thumbnail = icon,fanart = os . path . join (IMAGES,"background.jpg"),folder = False,isPlayable=True )
#GET TV ARCHIVE	
def get_tv_archive(params):
	r = requests.get(url=panel_url+"player_api.php?username="+kasutajanimi+"&password="+parool+"&action=get_live_streams")
	data = json.loads(r.content.decode())
	for streams in data:
		if not streams["tv_archive"]:
			continue
		if streams["stream_icon"]:
			icon = streams["stream_icon"]
		else:
			icon = os.path.join(IMAGES,"replay_icon.png")
		name = streams["name"]
		stream_id = streams["stream_id"]
		plot = "Archive length: "+streams["tv_archive_duration"]+" days"
		plugintools.add_item ( action = "get_tv_archive_contents" , title = name ,url=str(stream_id) ,plot = plot,thumbnail = icon,fanart = os . path . join (IMAGES,"background.jpg"), folder = True )
	xbmc.executebuiltin("Container.SetViewMode(55)")
#GET TV ARCHIVE CONTENTS
def get_tv_archive_contents(params):
	id = params.get("url")
	r = requests.get(url=panel_url+"player_api.php?username="+kasutajanimi+"&password="+parool+"&action=get_simple_data_table&stream_id="+id)
	data = json.loads(r.content.decode())
	for streams in data["epg_listings"]:
		if not streams["has_archive"]:
			continue
		if not streams["start"]:
			continue
		icon = os.path.join(IMAGES,"replay_icon.png")
		name = base64.b64decode(streams["title"]).decode("UTF-8")
		stream_id = streams["id"]
		plot = base64.b64decode(streams["description"]).decode("UTF-8")
		start = streams["start"]
		end = streams["end"]
		#plugintools.log(start+" "+end)
		format = "%Y-%m-%d %H:%M:%S"
		start_obj = datetime.datetime(*(time.strptime(start, format)[0:6]))
		end_obj = datetime.datetime(*(time.strptime(end, format)[0:6]))
		start_api_obj = start_obj.strftime("%Y-%m-%d:%H-%M")
		#start_obj = datetime.datetime.strptime(start, "%Y-%m-%d %H:%M:%S")
		#end_obj = datetime.datetime.strptime(end, "%Y-%m-%d %H:%M:%S")
		difference = end_obj - start_obj
		duration = difference.total_seconds()
		duration = round(duration / 60)
		archive_url = panel_url+"streaming/timeshift.php?username="+kasutajanimi+"&password="+parool+"&stream="+str(id)+"&start="+start_api_obj+"&duration="+str(duration)
		#plugintools.log(archive_url)
		plugintools.add_item ( action = "player" , title = start+" "+name ,url=archive_url ,plot = plot,thumbnail = icon,fanart = os . path . join (IMAGES,"background.jpg"), folder = False,isPlayable= True )
	xbmc.executebuiltin("Container.SetViewMode(55)")

#PLAYER
def player(params):
	stream_url = params.get("url")
	plugintools.log("Playing: "+stream_url)
	plugintools.play_resolved_url(stream_url)
#GET SHORT EPG
def get_short_epg(id):
	r = requests.get(url=panel_url+"player_api.php?username="+kasutajanimi+"&password="+parool+"&action=get_short_epg&stream_id="+str(id)+"&limit=1")
	data = json.loads(r.content.decode())
	short_epg = ""
	for show in data["epg_listings"]:
		name = base64.b64decode(show["title"]).decode("UTF-8")
		description = base64.b64decode(show["description"]).decode("UTF-8")
		#start = datetime.datetime.fromtimestamp(int(show["start_timestamp"])).strftime("%H:%M")
		short_epg+= name+"\n"+description
	return short_epg
#GET VOD INFO
def get_vod_info_from_api(id):
	r = requests.get(url=panel_url+"player_api.php?username="+kasutajanimi+"&password="+parool+"&action=get_vod_info&vod_id="+str(id))
	data = json.loads(r.content.decode())
	#print(data)
	plot = data["info"]["plot"]
	return plot
#JSON TESTS
def get_vod_cache(id):
	f = open(os.path.join(CACHE,"vod.txt" ),"r",encoding="utf-8")
	cache = json.loads(f.read())
	f.close
	return cache
def save_vod_cache(new_cache):
	f = open(os.path.join(CACHE,"vod.txt" ),"w",encoding="utf-8")
	f.write(json.dumps(new_cache))
	f.close()
	plugintools.log("New vod cache is saved")
def settings(params):
	plugintools.open_settings_dialog()
def login():
	r = requests.get(url=panel_url+"player_api.php?username="+kasutajanimi+"&password="+parool)
	if r.content.decode():
		data = json.loads(r.content.decode())
		auth = data["user_info"]["auth"]
	else:
		auth = 0
	return auth
def is_file_older_than (file, delta): 
	cutoff = datetime.utcnow() - delta
	mtime = datetime.utcfromtimestamp(os.path.getmtime(file))
	if mtime < cutoff:
		return True
	return False
def xmltv():
	xmltv_url = panel_url+"xmltv.php?username="+kasutajanimi+"&password="+parool
	xmltv = os.path.join(plugintools.get_runtime_path(),"xmltv.xml")
	if exists(xmltv) == True:
		plugintools.log("XMLTV file exists")
		file_expired = is_file_older_than(xmltv, timedelta(days=1))
		if file_expired == True:
			plugintools.log("XMLTV file expired")
			plugintools.message("XMLTV file is old","Press OK to download XMLTV file,this may take some time...")
			response = requests.get(url=xmltv_url)
			f = open(xmltv, "wb")
			f.write(response.content)
			f.close()
			#pDialog.update(100, "Update complete")
		else:
			plugintools.log("XMLTV file up to date")
			return
	else:
		plugintools.log("XMLTV file doesnt exist")
		plugintools.message("XMLTV file not found","Press OK to download XMLTV file,this may take some time...")
		response = requests.get(url=xmltv_url)
		f = open(xmltv, "wb")
		f.write(response.content)
		f.close()
def on_air():
	import _strptime
	plugintools.log("Getting whats playing from xmltv")
	xmltv = os.path.join(plugintools.get_runtime_path(),"xmltv.xml")
	tree = ET.parse(xmltv)
	root = tree.getroot()
	programmes = []
	offset = plugintools.get_setting("kava_offset")
	now = datetime.now()
	current_time = now.strftime("%Y%m%d%H%M%S")
	current_time = datetime(*(time.strptime(current_time, "%Y%m%d%H%M%S")[0:6]))#datetime.strptime(current_time, "%Y%m%d%H%M%S")
	on_air = {}
	for item in root.findall("programme"):
		start = item.attrib["start"]
		start = start.split(" ")
		start = datetime(*(time.strptime(start[0], "%Y%m%d%H%M%S")[0:6]))#datetime.strptime(start[0], "%Y%m%d%H%M%S")
		end = item.attrib["stop"]
		end = end.split(" ")
		end = datetime(*(time.strptime(end[0], "%Y%m%d%H%M%S")[0:6]))#datetime.strptime(end[0], "%Y%m%d%H%M%S")
		if "+" in offset:
			hours = offset.replace("+","")
			start = start + timedelta(hours=int(hours), minutes=0)
			end = end + timedelta(hours=int(hours), minutes=0)
		else:
			hours = offset.replace("-","")
			start = start - timedelta(hours=int(hours), minutes=0)
			end = end - timedelta(hours=int(hours), minutes=0)
		if current_time > start and current_time < end and item.find("title").text is not None:
			on_air[item.attrib["channel"]+"-time"] = start.strftime("%H:%M")
			on_air[item.attrib["channel"]+"-title"] = item.find("title").text
			on_air[item.attrib["channel"]+"-desc"] = "No information available"
			if item.find("desc").text is not None:
				on_air[item.attrib["channel"]+"-desc"] = item.find("desc").text
	return on_air
run()
